#!/bin/bash
MODEL_PATH=$1
set -e # exit on error
pred_file=${MODEL_PATH}/vqa_k_test_minus_llava_5k_prompt/answers/merge.jsonl

python inf_qwen_vl.py eval \
        --model-path ${MODEL_PATH} \
        --question-file <DATA_FOLDER>/vqa/vqa_k_test_minus_llava_5k.llava_eval.prompt.jsonl   \
        --image-folder <DATA_FOLDER> \
        --answer-file ${pred_file}

output_file=${MODEL_PATH}/vqa_k_test_minus_llava_5k_prompt/pred_probs_only_yes_or_no/merge.jsonl
python inf_qwen_vl.py get_pred_prob_only_yes_or_no \
        --model-path ${MODEL_PATH} \
        --question-file <DATA_FOLDER>/vqa/vqa_k_test_minus_llava_5k.llava_eval.prompt.jsonl   \
        --image-folder <DATA_FOLDER> \
        --pred_file ${pred_file} \
        --answer-file ${output_file} \
        --overwrite 

